/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(u_WindowSize.x*0.25,0.0,0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

//parameters

const int iterations=50;
const float bailout=1.0e5;
const float brightness=.85;
const float saturation=.6;
const float zoom=0.5;

//------------------ ------------------------------------------
// complex number operations
vec2 cadd( vec2 a, float s ) { return vec2( a.x+s, a.y ); }
vec2 cmul( vec2 a, vec2 b )  { return vec2( a.x*b.x - a.y*b.y, a.x*b.y + a.y*b.x ); }
vec2 cdiv( vec2 a, vec2 b )  { float d = dot(b,b); return vec2( dot(a,b), a.y*b.x - a.x*b.y ) / d; }
vec2 cinv( vec2 z)  { float d = dot(z,z); return vec2( z.x, -z.y ) / d; }
vec2 csqr( vec2 a ) { return vec2(a.x*a.x-a.y*a.y, 2.0*a.x*a.y ); }
vec2 csqrt( vec2 z ) { float m = length(z); return sqrt( 0.5*vec2(m+z.x, m-z.x) ) * vec2( 1.0, sign(z.y) ); }
vec2 conj( vec2 z ) { return vec2(z.x,-z.y); }
vec2 cpow( vec2 z, float n ) { float r = length( z ); float a = atan( z.y, z.x ); return pow( r, n )*vec2( cos(a*n), sin(a*n) ); }
vec2 cexp( vec2 z) {  return exp( z.x )*vec2( cos(z.y), sin(z.y) ); }
vec2 clog( vec2 z) {  float d = dot(z,z);return vec2( 0.5*log(d), atan(z.y,z.x)); }
vec2 csin( vec2 z) { float r = exp(z.y); return 0.5*vec2((r+1.0/r)*sin(z.x),(r-1.0/r)*cos(z.x));}
vec2 ccos( vec2 z) { float r = exp(z.y); return 0.5*vec2((r+1.0/r)*cos(z.x),-(r-1.0/r)*sin(z.x));}
//------------------------------------------------------------

vec2 z0;
vec2 zavg;
vec2 zn;

//formulas

vec2 f1( vec2 x ){return csqr(x) + z0  ;}//Mandelbrot
vec2 f2( vec2 x ){return (csqr(x+z0)- x+ z0)*0.5  ;}
vec2 f3( vec2 x ){return cinv(x+z0)+ x-z0  ;}//Infinity
vec2 f4( vec2 x ){return (x+cinv(x)+ z0+cinv(z0))*-.5  ;}
vec2 f5( vec2 x ){return (csqr(x-z0)+ x+z0)  ;}



vec2 f( vec2 x ){float t = 0.5+0.5*cos(0.1*iGlobalTime);return (f1(x)*t+f3(x)*(1.0-t));}

void main(void)
{
    vec3 color=vec3(0.);
    vec2 p=(gl_FragCoord.xy-iMouse.xy)/ iResolution.xy - 0.5;
    p.x*=iResolution.x/iResolution.y;
    p/=zoom*0.5;
    float avg=0.;
    zavg=vec2(0.);
    zn=normalize(p);			
    vec2 z=p;
    z0=p;
    for (int i=0; i<iterations; i++) {

	z=f(z);
				
	float l=length(z-zavg);
        l= max(l,1.0/l);
        if(l>bailout){
            float k = sqrt(sqrt(bailout/l))/float(i+1);
            zn=k*normalize(z)+(1.-k)*zn;
            break;
        }
				                          
        float k = 1./float(i+1);
        avg = k*l+(1.-k)*avg;
        zavg=k*z+(1.-k)*zavg;
        zn=k*normalize(z)+(1.-k)*zn;
        			
    }
		   
    color=0.2+abs(vec3(zn.x*zn.x,zn.x*zn.x,zn.y));
    if(avg>1.)avg=1./avg;
    color*=1.0-avg;	
    color=mix(vec3(length(color)),color,saturation)*brightness;	
    gl_FragColor = vec4(color,1.0);
}